/*	Renegade Scripts.dll
	SSGM Gamelog scripts
	Copyright 2007 Mac, Jonathan Wilson, Whitedragon(MDB)

	This file is part of the Renegade scripts.dll
	The Renegade scripts.dll is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2, or (at your option) any later
	version. See the file COPYING for more details.
	In addition, an exemption is given to allow Run Time Dynamic Linking of this code with any closed source module that does not contain code covered by this licence.
	Only the source code to the module(s) containing the licenced code has to be released.
*/

#ifndef GAMELOG_H
#define GAMELOG_H

#include "gmscripts.h"

void Gamelog_Level_Loaded();
void Gamelog_GameOver(const char* WinType);
void Gamelog_ObjectHook(GameObject *obj);
void Gamelog_Chat_Hook(int PlayerID, int Type, const wchar_t *Message);


class Gamelog_Building : public MDB_SSGM_Base {
	void NewCreated(GameObject *obj);
	void Destroyed(GameObject *obj);
	void Killed(GameObject *obj, GameObject *shooter);
	void Damaged(GameObject *obj, GameObject *damager, float damage);
};

class Gamelog_Soldier : public ScriptImpClass {
	void Created(GameObject *obj);
	void Destroyed(GameObject *obj);
	void Killed(GameObject *obj, GameObject *shooter);
	void Damaged(GameObject *obj, GameObject *damager, float damage);
	void Timer_Expired(GameObject *obj, int number);
};

class Gamelog_Vehicle : public ScriptImpClass {
	void Created(GameObject *obj);
	void Destroyed(GameObject *obj);
	void Killed(GameObject *obj, GameObject *shooter);
	void Damaged(GameObject *obj, GameObject *damager, float damage);
	void Timer_Expired(GameObject *obj, int number);
	void Custom(GameObject *obj, int message, int param, GameObject *sender);

};

class Gamelog_Scores : public MDB_SSGM_Base {
	void NewCreated(GameObject *obj);
	void Timer_Expired(GameObject *obj, int number);
	void Custom(GameObject *obj, int message, int param, GameObject *sender);

};

class Gamelog_Beacon : public ScriptImpClass {
	void Created(GameObject *obj);
	void Destroyed(GameObject *obj);
	void Killed(GameObject *obj, GameObject *shooter);
	void Damaged(GameObject *obj, GameObject *damager, float damage);
};

class Gamelog_Crate : public ScriptImpClass {
	void Created(GameObject *obj);
	void Destroyed(GameObject *obj);
	void Killed(GameObject *obj, GameObject *shooter);
	void Damaged(GameObject *obj, GameObject *damager, float damage);
};

class Gamelog_Mine : public ScriptImpClass {
	void Destroyed(GameObject *obj);
	void Killed(GameObject *obj, GameObject *shooter);
	void Damaged(GameObject *obj, GameObject *damager, float damage);
	void Created(GameObject *obj);
	char type[20];
	bool WasDisarmed;
};

#endif
